#! /bin/bash

declare -a gpu_list=(0 0 0 0 0)
declare -a cpu_list=("5-12" "13-20" "21-27" "28-35" "36-43" "44-51" )

declare -a config_name=("reddit_test_SDMP1.yml")
config_root=../config/reddit
dict_root=../result/reddit_SAGE_SDMP

root_result_path=../result/reddit_SAGE_SDMP_TEST
GNN_target_path=../result/reddit/SAGE

host_name=`uname -n`

for dict_folder in ${dict_root}/*; do
    echo "Go over dict folder ${dict_folder}."
    for ((idx=0; idx<${#config_name[@]}; ++idx)); do
        data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
        cur_result_path=${host_name}_${data_time}
        taskset -c ${cpu_list[$idx]} python ../main_test_SDMP.py --data ../dataset --dict $dict_folder --config ${config_root}/${config_name[$idx]} --device "cuda:${gpu_list[$idx]}" --result "${root_result_path}/${cur_result_path}" --gnn $GNN_target_path> /dev/null &
        pids[$idx]=$!
        sleep 1
        done # end of for over train confi
    echo "Done this round of start!"
    for pid in ${pids[*]}; do
        wait $pid
    done
done # end forloop with dictionary

